package mcfall.raytracer.objects;

import mcfall.math.Point;
import mcfall.math.Vector;
import mcfall.raytracer.LightSource;

public class AmbientLightSource extends LightSource {

	private static final RGBIntensity zero = new RGBIntensity (0.0, 0.0, 0.0);
	private RGBIntensity returnIntensity;
	
	public AmbientLightSource(double red, double green, double blue) {
		super(red, green, blue, new Point(0,0,0));
	}

	public AmbientLightSource(double intensity) {
		super(intensity, new Point(0, 0, 0));		
	}
	
	@Override
	public RGBIntensity computeDiffuse(Point objectLocation, Vector objectNormal) {
		if (returnIntensity == null) {
			returnIntensity = new RGBIntensity(red.getValue(), green.getValue(), blue.getValue());
		}
		return returnIntensity;
	}

	@Override
	public RGBIntensity computeSpecular(Point cameraLocation, Point objectLocation, Vector objectNormal, int falloff) {
		return zero;
	}

	/**
	 * Specifies that ambient lights are <b>not</b> susceptible to blocking by shadowing
	 */
	@Override
	public boolean isSubjectToShadowing() {
		return false;
	}
	
	
}
